/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rbf.BusyException;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.AbortThread;
import com.ibm.hwmca.fw.rbf.impl.HandlerPreparer;
import com.ibm.hwmca.fw.rbf.impl.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RecoveryThread;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.rbf.impl.ResultReporter;
import com.ibm.hwmca.fw.rbf.impl.persist.RbfRequestPersistence;
import com.ibm.hwmca.fw.rbf.impl.persist.RequestPersistencePMImpl;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class RequestManager {
    private static final String TRACE_MASKT = "XRBFRQMT";
    private static final String TRACE_MASKF = "XRBFRQMF";
    private static final String TRACE_MASKD = "XRBFRQMD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-ReqMgr");
    private static RequestManager requestManager = null;
    private static RbfRequestPersistence requestPersistence = null;
    private List requests = new ArrayList();
    private Object requestsLock = new Object();
    private static final int REQUESTS_MAX = 150;

    private RequestManager() throws PersistenceNotInitializedException {
        try {
            this.requests = requestPersistence.loadRequests();
            if (!this.requests.isEmpty()) {
                RecoveryThread recovery = new RecoveryThread(new Date().toString(), this.getAllRequests());
                recovery.start();
            }
        }
        catch (Exception e) {
            throw new PersistenceNotInitializedException(e.getClass().getName() + " while recovering requests from persistence: " + e.getMessage());
        }
        Trace.trace(TRACE_MASKT, "<> RequestManager()");
    }

    public static synchronized RequestManager getRequestManager() throws PersistenceNotInitializedException {
        return RequestManager.getRequestManager(null);
    }

    public static synchronized RequestManager getRequestManager(RbfRequestPersistence requestPersistence) throws PersistenceNotInitializedException {
        if (requestManager == null) {
            if (requestPersistence == null) {
                String msg = "RBF request persistence not specified";
                throw new PersistenceNotInitializedException(msg);
            }
            RequestManager.requestPersistence = requestPersistence;
            requestManager = new RequestManager();
        }
        return requestManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(RbfRequest request) throws RbfException {
        RbfRequestId requestId = request.getIdentifier();
        Trace.trace(TRACE_MASKT, "-> submit() " + requestId);
        Object object = this.requestsLock;
        synchronized (object) {
            RequestTrackingData trackingData;
            if (this.requests.contains(request)) {
                String errorMsg = "Internal error: Duplicate request identifier " + requestId;
                Trace.trace(TRACE_MASKF, errorMsg);
                throw new RbfException(errorMsg);
            }
            if (this.requests.size() >= 150) {
                throw new BusyException("Exceeded maximum number of requests 150");
            }
            RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
            synchronized (requestTrackingData) {
                try {
                    trackingData.state = 4;
                    trackingData.submitDate = new Date();
                    trackingData.origin = FcsServer.getFcsServer().getLocalMachineId();
                    if (request.isPersistent()) {
                        requestPersistence.storeRequest(request, true);
                    }
                }
                catch (RbfException rbfe) {
                    trackingData.state = 0;
                    trackingData.submitDate = null;
                    trackingData.origin = null;
                    throw rbfe;
                }
            }
            this.requests.add(request);
            Trace.trace(TRACE_MASKF, "Submitted: " + request.toDebugString());
            Trace.trace(TRACE_MASKF, this.requests.size() + " managed requests");
        }
        HandlerPreparer.prepareHandlers(request);
        Trace.trace(TRACE_MASKT, "<- submit() " + requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changed(RbfRequest request) throws RbfException {
        RbfRequestId requestId = request.getIdentifier();
        Trace.trace(TRACE_MASKT, "-> changed() " + requestId);
        Object object = this.requestsLock;
        synchronized (object) {
            if (this.requests.contains(request) && request.isPersistent()) {
                requestPersistence.storeRequest(request, false);
            }
        }
        Trace.trace(TRACE_MASKT, "<- changed() " + requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(RbfRequest request) {
        RbfRequestId requestId = request.getIdentifier();
        Trace.trace(TRACE_MASKT, "-> close() " + requestId);
        Object object = this.requestsLock;
        synchronized (object) {
            if (this.requests.contains(request)) {
                this.requests.remove(request);
                if (request.isPersistent()) {
                    try {
                        requestPersistence.removeRequest(request);
                    }
                    catch (RbfException rbfe) {
                        // empty catch block
                    }
                }
                Trace.trace(TRACE_MASKF, this.requests.size() + " managed requests");
            }
        }
        Trace.trace(TRACE_MASKT, "<- close() " + requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbfRequest getRequest(RbfRequestId id) {
        if (id == null) {
            return null;
        }
        RbfRequest request = null;
        Object object = this.requestsLock;
        synchronized (object) {
            Iterator iterator = this.requests.iterator();
            while (iterator.hasNext() && request == null) {
                RbfRequest candidate = (RbfRequest)iterator.next();
                if (!candidate.getIdentifier().equals(id)) continue;
                request = candidate;
            }
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getAllRequests() {
        Object object = this.requestsLock;
        synchronized (object) {
            return new ArrayList(this.requests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(RbfRequest request) {
        RequestTrackingData trackingData;
        RbfRequestId requestId = request.getIdentifier();
        Trace.trace(TRACE_MASKT, "-> cancel() " + requestId);
        boolean doit = false;
        HashSet<MachineId> toBeAborted = null;
        RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
        synchronized (requestTrackingData) {
            if (trackingData.isStateChangeValid(trackingData.state, 12)) {
                trackingData.state = 12;
                trackingData.canceled = true;
                trackingData.addHistory("Canceled at submitter " + RbfUtils.getMachineInfo(trackingData.origin));
                toBeAborted = new HashSet<MachineId>();
                if (trackingData.preparing != null) {
                    toBeAborted.addAll(trackingData.preparing);
                    trackingData.addAborting(trackingData.preparing);
                    trackingData.preparing.clear();
                }
                if (!trackingData.isHandlerNeeded() && trackingData.handler != null) {
                    toBeAborted.add(trackingData.handler);
                    trackingData.addAborting(trackingData.handler);
                }
                doit = true;
            }
        }
        if (doit) {
            if (toBeAborted != null && !toBeAborted.isEmpty()) {
                AbortThread at = new AbortThread(request, toBeAborted, 4);
                at.start();
            }
            ResultReporter.reportAndClose(request, 36, null);
        }
        Trace.trace(TRACE_MASKT, "<- cancel() " + requestId);
    }

    void fcsStateChanged(FcsEvent event) {
        int type = event.getEventType();
        int details = event.getEventDetails();
        MachineId machine = event.getMachineId();
        String machineInfo = RbfUtils.getMachineInfo(machine);
        if (type == 1 && details != 51) {
            if (details == 53) {
                this.machineUnavailable(machine);
            } else if (details == 52) {
                this.machineUnavailable(machine);
            } else if (details == 54) {
                this.machineChanged(machine, event.getOldMachineId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void machineUnavailable(MachineId machine) {
        Iterator brokered = this.getAllRequests().iterator();
        while (brokered.hasNext()) {
            RequestTrackingData trackingData;
            RbfRequest request = (RbfRequest)brokered.next();
            RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
            synchronized (requestTrackingData) {
                trackingData.removePreparing(machine);
                trackingData.removeAborting(machine);
                if (trackingData.state == 4) {
                    if (trackingData.isHandlerNeeded() && !trackingData.isAnyPreparation()) {
                        HandlerPreparer.prepareHandlers(request);
                    }
                } else if (trackingData.state == 8) {
                    if (trackingData.isHandlerNeeded()) {
                        if (!trackingData.isAnyPreparation()) {
                            HandlerPreparer.prepareHandlers(request);
                        }
                    } else if (machine.equals(trackingData.handler)) {
                        trackingData.handlerOutage = true;
                        HandlerPreparer.prepareHandlers(request);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void machineChanged(MachineId machine, MachineId oldMachine) {
        Iterator brokered = this.getAllRequests().iterator();
        while (brokered.hasNext()) {
            RequestTrackingData trackingData;
            RbfRequest request = (RbfRequest)brokered.next();
            RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
            synchronized (requestTrackingData) {
                if (oldMachine.equals(trackingData.origin)) {
                    trackingData.addHistory("Local machine now " + RbfUtils.getMachineInfo(machine));
                    trackingData.origin = machine;
                }
                if (oldMachine.equals(trackingData.handler)) {
                    trackingData.setHandler(machine);
                }
                if (trackingData.handlerSubset != null && trackingData.handlerSubset.remove(oldMachine)) {
                    trackingData.handlerSubset.add(machine);
                }
                if (trackingData.removePreparing(oldMachine)) {
                    trackingData.addPreparing(machine);
                }
                if (trackingData.removeAborting(oldMachine)) {
                    trackingData.addAborting(machine);
                }
                if (trackingData.removeUnusable(oldMachine)) {
                    trackingData.addUnusable(machine);
                }
            }
            try {
                this.changed(request);
            }
            catch (RbfException rbfe) {
                // empty catch block
            }
        }
    }

    static {
        try {
            RequestManager.getRequestManager(new RequestPersistencePMImpl());
        }
        catch (PersistenceNotInitializedException pnie) {
            String desc = "Internal error: " + pnie.getClass().getName() + " during static initialization:\n" + RbfUtils.getStackTrace(pnie);
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1061);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo());
            fl.log();
        }
    }
}

